﻿#include "precompiled.h"
#include "common.h"
#include "RenderTarget.h"

//const auto rtTexFormatStandard = DXGI_FORMAT_B8G8R8A8_UNORM; // Standard colors
//const auto rtTexFormatHDR = DXGI_FORMAT_R16G16B16A16_FLOAT; // HDR
//const auto rtSrvFormat = rtTexFormat;
//const auto rtViewFormat = rtTexFormat;

// Allow reading from the render target
const auto rtBindFlags = D3D11_BIND_RENDER_TARGET | D3D11_BIND_SHADER_RESOURCE;

namespace RTCam {

RenderTarget::RenderTarget(_In_z_ const char* name) :
	Texture(name),
	m_renderTargetView(nullptr)
{
}


RenderTarget::~RenderTarget(void)
{
}

void RenderTarget::Init(_In_ ID3D11Device1* device, size_t width, size_t height, DXGI_FORMAT format)
{
	// TODO: Have rendertargets that are not mip-enabled?
	Texture::InitTexture(device, width, height, format, format, rtBindFlags, true);

	// Create the render target view
	CD3D11_RENDER_TARGET_VIEW_DESC rtvDesc(
		D3D11_RTV_DIMENSION_TEXTURE2D,
		format
		);

	ThrowIfFailed(
		device->CreateRenderTargetView(
		m_texture.Get(),
		&rtvDesc,
		&m_renderTargetView
		)
	);

	SetDebugObjectName(m_renderTargetView.Get(), m_name + "View");
}

void RenderTarget::ReleaseResources()
{
	m_renderTargetView = nullptr;

	Texture::ReleaseResources();
}

} // end namespace